<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function activation_processes()
    {
        return $this->hasMany('App\Models\ActivationProcess');
    }

    public function favResturants()
    {
        return $this->belongsToMany('App\Models\Resturant');
    }

    public function reviews()
    {
        return $this->hasMany('App\Models\Review');
    }

    public function addresses()
    {
        return $this->hasMany('App\Models\Address');
    }

    public function carts()
    {
        return $this->hasMany('App\Models\Cart');
    }

    public function order()
    {
        return $this->hasMany('App\Models\Order');
    }

}